package com.ejie.ab04b.service.serviciocorrespondencia;

import java.util.Locale;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

import com.ejie.ab04b.exception.ServicioCorrespondenciaException;
import com.ejie.ab04b.webservice.client.aa66.AA66Notificaciones;
import com.ejie.ab04b.webservice.client.aa66.IdentTramitadorCondicionalWs;
import com.ejie.ab04b.webservice.client.aa66.IdentTramitadorWs;
import com.ejie.ab04b.webservice.client.aa66.RemesaOutWs;
import com.ejie.ab04b.webservice.client.aa66.RemesaWs;
import com.ejie.ab04b.webservice.client.aa66.SituacionEntregaWs;
import com.ejie.ab04b.webservice.client.aa66.ZipEnvioWs;

/**
 * 
 * @author GFI-NORTE
 * 
 */
@Service()
public class ServicioCorrespondenciaService {

	@Autowired()
	private AA66Notificaciones aa66NotificacionesPort;

	private static final Logger LOGGER = LoggerFactory
			.getLogger(ServicioCorrespondenciaService.class);

	/**
	 * Crea un asiento de entrada en el registro presencial
	 * 
	 *  remesaEntrada
	 *            RemesaWs
	 * 
	 *  RemesaOutWs.
	 *
	 * @param remesaEntrada the remesa entrada
	 * @return the remesa out ws
	 * @throws ServicioCorrespondenciaException             excepción lanzada por el Servicio de Correspondencia
	 */
	public RemesaOutWs cargaMasiva(RemesaWs remesaEntrada)
			throws ServicioCorrespondenciaException {

		ServicioCorrespondenciaService.LOGGER
				.info(" LOG NEGOCIO: cargaMasiva --> START");

		RemesaOutWs response = null;
		try {
			response = this.aa66NotificacionesPort
					.cargaMasiva(remesaEntrada);

			ServicioCorrespondenciaService.LOGGER.info(
					" LOG NEGOCIO: remesa creada correctamente con #Remesa {} y #Coleccion {}",
					response.getCodigoRemesa(), response.getCodigoColeccion());

			ServicioCorrespondenciaService.LOGGER
					.info(" LOG NEGOCIO: cargaMasiva --> END");

			return response;
		} catch (Exception e) {
			ServicioCorrespondenciaService.LOGGER.error(
					" LOG NEGOCIO: Error en la llamada a cargaMasiva del Servicio de Correspondencia",
					e);
			throw new ServicioCorrespondenciaException(e,
					" LOG NEGOCIO: Error en la llamada a cargaMasiva del Servicio de Correspondencias");
		}
	}

	/**
	 * Obtiene un ZIP con los documentos que prueban el envío
	 * 
	 *  identTramitador
	 *            IdentTramitadorWs
	 * 
	 *  ZipEnvioWs.
	 *
	 * @param identTramitador the ident tramitador
	 * @return the zip envio ws
	 * @throws ServicioCorrespondenciaException             excepción lanzada por el Servicio de Correspondencia
	 */
	public ZipEnvioWs obtenerPruebaEnvio(IdentTramitadorWs identTramitador)
			throws ServicioCorrespondenciaException {

		ServicioCorrespondenciaService.LOGGER
				.info(" LOG NEGOCIO: obtenerPruebaEnvio --> START");

		ZipEnvioWs response = null;
		try {
			response = this.aa66NotificacionesPort
					.pruebaEntregaEnvio(identTramitador);

			ServicioCorrespondenciaService.LOGGER
					.info(" LOG NEGOCIO: ZipEnvioWs obtenido correctamente");

			ServicioCorrespondenciaService.LOGGER
					.info(" LOG NEGOCIO: obtenerPruebaEnvio --> END");

			return response;
		} catch (Exception e) {
			ServicioCorrespondenciaService.LOGGER.error(
					" LOG NEGOCIO: Error en la llamada a obtenerPruebaEnvio del Servicio de Correspondencia",
					e);
			throw new ServicioCorrespondenciaException(e,
					" LOG NEGOCIO: Error en la llamada a obtenerPruebaEnvio del Servicio de Correspondencias");
		}
	}

	/**
	 * Obtiene la situación en CORREOS del envío
	 * 
	 *  identTramitador
	 *            IdentTramitadorCondicionalWs
	 * 
	 *  SituacionEntregaWs.
	 *
	 * @param identTramitador the ident tramitador
	 * @return the situacion entrega ws
	 * @throws ServicioCorrespondenciaException             excepción lanzada por el Servicio de Correspondencia
	 */
	public SituacionEntregaWs actualizarSituacionEnvio(
			IdentTramitadorCondicionalWs identTramitador)
			throws ServicioCorrespondenciaException {

		ServicioCorrespondenciaService.LOGGER
				.info(" LOG NEGOCIO: actualizarSituacionEnvio --> START");

		SituacionEntregaWs response = null;
		try {
			response = this.aa66NotificacionesPort
					.situacionEntregaEnvio(identTramitador);

			ServicioCorrespondenciaService.LOGGER
					.info(" LOG NEGOCIO: ZipEnvioWs obtenido correctamente");

			ServicioCorrespondenciaService.LOGGER
					.info(" LOG NEGOCIO: actualizarSituacionEnvio --> END");

			return response;
		} catch (Exception e) {
			ServicioCorrespondenciaService.LOGGER.error(
					" LOG NEGOCIO: Error en la llamada a actualizarSituacionEnvio del Servicio de Correspondencia",
					e);
			throw new ServicioCorrespondenciaException(e,
					" LOG NEGOCIO: Error en la llamada a actualizarSituacionEnvio del Servicio de Correspondencias");
		}
	}

	/**
	 *  Locale.
	 *
	 * @return the locale
	 */
	public Locale getLocale() {
		return LocaleContextHolder.getLocale();
	}

}
